document.addEventListener("DOMContentLoaded", function () {
  // Select all the footer image sets and the middle images
  const footerImageSets = document.querySelectorAll(".footer-logo-image");
  const middleImages = document.querySelectorAll(".middle-logo-images img");

  // Initialize the index for the current set
  let currentSetIndex = 0;

  function preloadImages() {
    footerImageSets.forEach((set) => {
      const footerImages = set.querySelectorAll("img");
      footerImages.forEach((img) => {
        const link = document.createElement("link");
        link.rel = "preload";
        link.as = "image";
        link.href = img.src;
        document.head.appendChild(link); // Preload each image
      });
    });
  }

  // Function to update middle images based on the current set
  function updateMiddleImages() {
    // Clear the current active class
    footerImageSets.forEach((set) => set.classList.remove("active"));

    // Add active class to the current set
    footerImageSets[currentSetIndex].classList.add("active");

    // Get images from the current footer image set
    const footerImages =
      footerImageSets[currentSetIndex].querySelectorAll("img");

    // Update the middle images to match the current footer images
    middleImages.forEach((middleImage, i) => {
      middleImage.style.opacity = "0"; // Fade out
      //   setTimeout(() => {
      //     middleImage.src = footerImages[i % footerImages.length].src; // Change source
      //     middleImage.style.opacity = "1"; // Fade in
      //   }); // Match this timeout with the fade-out duration
      // });
      middleImage.src = footerImages[i % footerImages.length].src;

      // Add a loading indicator (optional)
      middleImage.classList.add("loading");

      // Remove the 'loading' class and fade in after image has fully loaded
      middleImage.onload = function () {
        middleImage.style.opacity = "1"; // Fade in
        middleImage.classList.remove("loading"); // Remove loading indicator
      };
    });
  }

  // Add click event listener to each footer image set
  footerImageSets.forEach((footerImageSet, index) => {
    footerImageSet.addEventListener("click", function () {
      currentSetIndex = index; // Update current index based on clicked set
      updateMiddleImages(); // Update images
    });
  });

  // Right icon click event
  const rightIcon = document.querySelector(".middle-logo-images .icon-play");
  rightIcon.addEventListener("click", function () {
    currentSetIndex = (currentSetIndex + 1) % footerImageSets.length; // Cycle to the next set
    updateMiddleImages(); // Update images
  });

  // Left icon click event
  const leftIcon = document.querySelector(".middle-logo-images .icon-backward");
  leftIcon.addEventListener("click", function () {
    currentSetIndex =
      (currentSetIndex - 1 + footerImageSets.length) % footerImageSets.length; // Cycle to the previous set
    updateMiddleImages(); // Update images
  });
  setInterval(() => {
    currentSetIndex = (currentSetIndex + 1) % footerImageSets.length; // Cycle to the next set
    updateMiddleImages(); // Update images automatically
  }, 6000);
  preloadImages();
  updateMiddleImages();
});
