<?php

// Simple Nochex checkout redirector
// Configure these values for your Nochex account and URLs
$SIMULATE_NOCHEX = true; // default; can be overridden by `nochex_config.php`

// Load configuration if the user created `nochex_config.php` (do not commit that file)
$configFile = __DIR__ . '/nochex_config.php';
$config = null;
if (file_exists($configFile)) {
    $config = include $configFile;
    if (isset($config['simulate'])) $SIMULATE_NOCHEX = (bool)$config['simulate'];
}
$TEST_MODE = isset($config['test_mode']) ? (bool)$config['test_mode'] : false;

// Default endpoint and merchant id (can be overridden via config)
$NOCHEX_URL = $config['nochex_url'] ?? 'https://secure-test.nochex.com/';
$MERCHANT_ID = $config['merchant_id'] ?? 'michael@25poundlogodesign.co.uk';
$hostBase = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://') . ($_SERVER['HTTP_HOST'] ?? 'example.com');
$baseDir = rtrim(dirname($_SERVER['REQUEST_URI']), '\/');
// Allow overriding the public site base from config (useful when behind proxies/ngrok or deploying to a different host)
if (!empty($config['site_base'])) {
    $siteBase = rtrim($config['site_base'], '\/');
    $SUCCESS_URL = $siteBase . $baseDir . '/nochex_success.php';
    $CANCEL_URL  = $siteBase . $baseDir . '/nochex_cancel.php';
    $NOTIFY_URL  = $siteBase . $baseDir . '/nochex_callback.php';
} else {
    $SUCCESS_URL = $hostBase . $baseDir . '/nochex_success.php';
    $CANCEL_URL  = $hostBase . $baseDir . '/nochex_cancel.php';
    $NOTIFY_URL  = $hostBase . $baseDir . '/nochex_callback.php';
}
$TEST_SUCCESS_URL = !empty($config['test_success_url']) ? $config['test_success_url'] : $SUCCESS_URL;

$amount = isset($_POST['amount']) ? trim($_POST['amount']) : '';
$order_id = isset($_POST['order_id']) ? trim($_POST['order_id']) : (string)random_int(1000000, 9999999);
$package_name = isset($_POST['package_name']) ? trim($_POST['package_name']) : '';
$customer_email = isset($_POST['customer_email']) ? trim($_POST['customer_email']) : '';
$pricing_summary = isset($_POST['pricing_summary']) ? trim($_POST['pricing_summary']) : '';
$firstbutton = isset($_POST['firstbutton']) ? trim((string)$_POST['firstbutton']) : '0';
$secondbutton = isset($_POST['secondbutton']) ? trim((string)$_POST['secondbutton']) : '0';
$lastbutton = isset($_POST['lastbutton']) ? trim((string)$_POST['lastbutton']) : '0';

if ($order_id === '') {
    $order_id = (string)random_int(1000000, 9999999);
}

function appendQueryParam($url, $key, $value)
{
    $sep = (strpos($url, '?') === false) ? '?' : '&';
    return $url . $sep . rawurlencode($key) . '=' . rawurlencode($value);
}

$SUCCESS_URL = appendQueryParam($SUCCESS_URL, 'order_id', $order_id);
$CANCEL_URL = appendQueryParam($CANCEL_URL, 'order_id', $order_id);
if (!empty($TEST_SUCCESS_URL)) {
    $TEST_SUCCESS_URL = appendQueryParam($TEST_SUCCESS_URL, 'order_id', $order_id);
}

setcookie('last_order_id', $order_id, [
    'expires' => time() + 86400,
    'path' => '/',
    'httponly' => true,
    'samesite' => 'Lax',
]);

function isTruthyFlag($value)
{
    $v = strtolower(trim((string)$value));
    return in_array($v, ['1', 'true', 'yes', 'on'], true);
}

$hasExpress = isTruthyFlag($firstbutton);
$hasBlackWhite = isTruthyFlag($secondbutton);
$hasSaveAdditional = isTruthyFlag($lastbutton);
$GBP = "\u{00A3}";
$TM = "\u{2122}";

$referer = isset($_SERVER['HTTP_REFERER']) ? strtolower((string)$_SERVER['HTTP_REFERER']) : '';
$isBoostSpecial = false;
if (strtolower($package_name) === 'thebest package') {
    if (strpos($referer, 'specialoffers-thebest') !== false) {
        $isBoostSpecial = false;
    } elseif (
        strpos($referer, 'checkout-secondpage') !== false ||
        strpos($referer, 'specialoffers-excel') !== false ||
        strpos($referer, 'specialoffers-surge') !== false ||
        strpos(strtolower($pricing_summary), 'boost') !== false ||
        preg_match('/(^|\\D)76(\\D|$)/', (string)$pricing_summary)
    ) {
        $isBoostSpecial = true;
    }
}

$baseSale = 0;
$packageLinePlain = '';
$packageLineHtml = '';
switch (strtolower($package_name)) {
    case 'lite package':
        $baseSale = 25;
        $packageLinePlain = "Lite Package Sale: {$GBP}50 {$GBP}25.";
        $packageLineHtml = "Lite Package Sale: <span class=\"old-price\">{$GBP}50</span> {$GBP}25.";
        break;
    case 'surge package':
        $baseSale = 35;
        $packageLinePlain = "Surge Package Sale: {$GBP}69 {$GBP}35.";
        $packageLineHtml = "Surge Package Sale: <span class=\"old-price\">{$GBP}69</span> {$GBP}35.";
        break;
    case 'excel package':
        $baseSale = 59;
        $packageLinePlain = "Excel Package Sale: {$GBP}125 {$GBP}59.";
        $packageLineHtml = "Excel Package Sale: <span class=\"old-price\">{$GBP}125</span> {$GBP}59.";
        break;
    case 'thebest package':
        $baseSale = $isBoostSpecial ? 76 : 95;
        $packageLinePlain = $isBoostSpecial
            ? "The Best{$TM} Package Boost Special Sale: {$GBP}190 {$GBP}95 {$GBP}76."
            : "The Best{$TM} Package Sale: {$GBP}190 {$GBP}95.";
        $packageLineHtml = $isBoostSpecial
            ? "The Best{$TM} Package Boost Special Sale: <span class=\"old-price\">{$GBP}190</span> <span class=\"old-price\">{$GBP}95</span> {$GBP}76."
            : "The Best{$TM} Package Sale: <span class=\"old-price\">{$GBP}190</span> {$GBP}95.";
        break;
    default:
        $baseSale = is_numeric($amount) ? (float)$amount : 0;
        $packageLinePlain = ($package_name !== '' ? $package_name : 'Package') . " Sale: {$GBP}" . $baseSale . '.';
        $packageLineHtml = htmlspecialchars($packageLinePlain, ENT_QUOTES, 'UTF-8');
        break;
}

$subtotalBeforeTierDiscount = $baseSale;
if ($hasExpress) $subtotalBeforeTierDiscount += 19;
if ($hasBlackWhite) $subtotalBeforeTierDiscount += 15;
if ($hasSaveAdditional) $subtotalBeforeTierDiscount -= 5;

$buyMoreDiscount = 0;
if ($subtotalBeforeTierDiscount > 80) {
    $buyMoreDiscount = 10;
} elseif ($subtotalBeforeTierDiscount > 50) {
    $buyMoreDiscount = 5;
}

$descriptionLinesPlain = [];
$descriptionLinesHtml = [];
if ($packageLinePlain !== '') $descriptionLinesPlain[] = $packageLinePlain;
if ($packageLineHtml !== '') $descriptionLinesHtml[] = $packageLineHtml;
if ($buyMoreDiscount > 0) {
    $line = "Buy More, Save More Discount Applied:" . " - {$GBP}" . $buyMoreDiscount . '.';
    $descriptionLinesPlain[] = $line;
    $descriptionLinesHtml[] = $line;
}
if ($hasSaveAdditional) {
    $line = "Save Additional {$GBP}5 Discount Applied:" . " - {$GBP}5.";
    $descriptionLinesPlain[] = $line;
    $descriptionLinesHtml[] = $line;
}
if ($hasExpress) {
    $descriptionLinesPlain[] = "24 Hours Express Delivery Sale:" . " {$GBP}40 {$GBP}19.";
    $descriptionLinesHtml[] = "24 Hours Express Delivery Sale:" . " <span class=\"old-price\">{$GBP}40</span> {$GBP}19.";
}
if ($hasBlackWhite) {
    $descriptionLinesPlain[] = "Black and White Additional Logo Design File Sale:" . " {$GBP}30 {$GBP}15.";
    $descriptionLinesHtml[] = "Black and White Additional Logo Design File Sale:" . " <span class=\"old-price\">{$GBP}30</span> {$GBP}15.";
}

$description_details = implode("\n", $descriptionLinesPlain);
$description_details_html = implode("<br>\n", $descriptionLinesHtml);
$description_items_html = $descriptionLinesHtml;
if ($description_details === '' && $pricing_summary !== '') {
    $description_details = $pricing_summary;
    $description_details_html = nl2br(htmlspecialchars($pricing_summary, ENT_QUOTES, 'UTF-8'));
    $description_items_html = preg_split('/\r\n|\r|\n/', htmlspecialchars($pricing_summary, ENT_QUOTES, 'UTF-8'));
}
if ($description_details === '') {
    $description_details = 'Order Payment';
    $description_details_html = 'Order Payment';
    $description_items_html = ['Order Payment'];
}

$descriptionCompactParts = [];
switch (strtolower($package_name)) {
    case 'lite package':
        $descriptionCompactParts[] = "Lite Package Sale: Was {$GBP}50 Sale {$GBP}25";
        break;
    case 'surge package':
        $descriptionCompactParts[] = "Surge Package Sale: Was {$GBP}69 Sale {$GBP}35";
        break;
    case 'excel package':
        $descriptionCompactParts[] = "Excel Package Sale: Was {$GBP}125 Sale {$GBP}59";
        break;
    case 'thebest package':
        if ($isBoostSpecial) {
            $descriptionCompactParts[] = "The Best{$TM} Package Boost Special Sale: Was {$GBP}190 Sale {$GBP}76";
        } else {
            $descriptionCompactParts[] = "The Best{$TM} Package Sale: Was {$GBP}190 Sale {$GBP}95";
        }
        break;
    default:
        $descriptionCompactParts[] = ($package_name !== '' ? $package_name : 'Package') . ": {$GBP}{$amount}";
        break;
}

if ($buyMoreDiscount > 0) $descriptionCompactParts[] = "Buy More, Save More Discount Applied: -{$GBP}{$buyMoreDiscount}";
if ($hasSaveAdditional) $descriptionCompactParts[] = "Save Additional {$GBP}5 Discount Applied: -{$GBP}5";
if ($hasExpress) $descriptionCompactParts[] = "24 Hours Express Delivery Sale: Was {$GBP}40 Sale {$GBP}19";
if ($hasBlackWhite) $descriptionCompactParts[] = "Black and White Additional Logo Design File Sale: Was {$GBP}30 Sale {$GBP}15";

$description_for_nochex = implode(' | ', $descriptionCompactParts);
if ($description_for_nochex === '') {
    $description_for_nochex = $description_details;
}

// Basic validation
if ($amount === '' || !is_numeric($amount)) {
    echo "Invalid amount provided.";
    exit;
}

// Log the order request
$logLine = sprintf("%s | Checkout requested | order_id=%s | amount=%s | package=%s\n", date('c'), $order_id, $amount, $package_name);
file_put_contents(__DIR__ . '/nochex_requests.log', $logLine, FILE_APPEND | LOCK_EX);

// Persist order to SQLite
$dbFile = __DIR__ . '/orders.sqlite';
if (file_exists(__DIR__ . '/db.php')) {
    require_once __DIR__ . '/db.php';
    try {
        insertOrder($order_id, (float)$amount, $package_name, $customer_email);
    } catch (Exception $e) {
        // log but do not block
        file_put_contents(__DIR__ . '/nochex_requests.log', date('c') . " | DB insert error: " . $e->getMessage() . "\n", FILE_APPEND | LOCK_EX);
    }
}
// If simulation mode is enabled, show a local simulated Nochex page so you can
// test the end-to-end flow (callback + redirect) without relying on external DNS.
if (!empty($SIMULATE_NOCHEX)) {
    $simPostUrl = $hostBase . $baseDir . '/nochex_callback.php';
    $successUrl = $hostBase . $baseDir . '/nochex_success.php';
    $cancelUrl = $hostBase . $baseDir . '/nochex_cancel.php';
?>
    <!doctype html>
    <html>

    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">

        <meta name="description"
            content="Logo design and custom logo design at great pricing. Logo design done well to help your business and brand." />
        <base href="" target="_self" /> <!-- base path for images -->
        <!-- <meta charset="utf-8"> -->
        <!-- <meta name="viewport" content="width=device-width,initial-scale=1"> -->
        <title>Secure Checkout  25PoundLogoDesign</title>
        <meta name="robots" content="index, follow" />

        <!-- <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.4.0/css/font-awesome.min.css"> -->
        <!-- Bootstrap by AD -->
        <link href="assets/css/newbootstrap.css" rel="stylesheet">
        <link rel="icon" href="assets/images/favicon.ico" />
        <link href="assets/css/main.css" rel="stylesheet">
        <link href="assets/css/style.min.css" rel="stylesheet">
        <!-- <link href="assets/css/css3-effects.min.css" rel="stylesheet">
    <link href="assets/css/jquery.loadmask.css" rel="stylesheet"> -->
        <link href="assets/css/media.min.css" rel="stylesheet">
        <!-- <link href="assets/css/newslider.css" rel="stylesheet"> -->


        <!-- <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;500;600;700;800&display=swap"
        rel="stylesheet"> -->
        <!-- <link href="assets/css/responsive_bootstrap_carousel_mega_min.css" rel="stylesheet"> -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css"
            integrity="sha512-SnH5WK+bZxgPHs44uWIX+LLJAJ9/2PkPKZ5QiAj6Ta86w+fsb2TkcmfRyVX3pBnMFcV7oQPJkl9QevSCWr3W6A=="
            crossorigin="anonymous" referrerpolicy="no-referrer" />
        <script src="//ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script>
        <!-- <script src="assets/js/bootstrap.min.js"></script> -->
        <link rel="preload" as="image" href="assets/images/video-image.png">
        <style>
            :root {
                --accent: #28a745;
                --danger: #dc3545;
                --muted: #6b7280
            }

            body {
                font-family: Inter, system-ui, Arial, Helvetica, sans-serif;
                background: #ffffff;
                color: #111;
                margin: 0;
                padding: 24px
            }

            .header {
                display: flex;
                align-items: center;
                gap: 16px;
                margin-bottom: 18px
            }

            .logo {
                height: 52px
            }

            .site-title {
                font-size: 18px;
                font-weight: 700
            }

            .site-sub {
                font-size: 13px;
                color: var(--muted)
            }

            .sim-header {
                display: flex;
                align-items: center;
                gap: 16px;
                margin-bottom: 18px;
                flex-wrap: wrap
            }

            .sim-header .logo {
                height: 52px;
                max-width: 220px;
                width: auto
            }

            .sim-header .site-title {
                font-size: 18px;
                font-weight: 700
            }

            .sim-header .site-sub {
                font-size: 13px;
                color: var(--muted)
            }

            .card {
                max-width: 820px;
                margin: 0 auto;
                background: #fff;
                border-radius: 12px;
                box-shadow: 0 8px 30px rgba(17, 24, 39, 0.08);
                overflow: hidden
            }

            .card-body {
                display: flex;
                gap: 24px;
                padding: 28px
            }

            .left {
                flex: 1
            }

            .right {
                width: 320px;
                background: linear-gradient(180deg, #f8fafc, #ffffff);
                padding: 20px;
                border-left: 1px solid #eef2f7
            }

            .h {
                font-size: 20px;
                font-weight: 700;
                margin: 0 0 8px
            }

            .muted {
                color: var(--muted);
                font-size: 14px
            }

            .order-row {
                display: flex;
                justify-content: space-between;
                align-items: center;
                padding: 12px 0;
                border-bottom: 1px dashed #eef2f7
            }

            .amount {
                font-size: 28px;
                color: var(--accent);
                font-weight: 800
            }

            .btn {
                display: inline-block;
                padding: 12px 20px;
                border-radius: 8px;
                border: 0;
                cursor: pointer;
                font-weight: 700
            }

            .btn-pay {
                background: var(--accent);
                color: #fff;
                box-shadow: 0 8px 18px rgba(34, 197, 94, 0.18);
            }

            .btn-cancel {
                background: var(--danger);
                color: #fff
            }

            .trust {
                display: flex;
                gap: 8px;
                align-items: center;
                margin-top: 12px
            }

            .trust img {
                height: 28px
            }

            .small {
                font-size: 13px;
                color: #334155
            }

            .old-price {
                text-decoration: line-through;
            }

            .desc-list {
                display: flex;
                flex-direction: column;
                gap: 6px;
                width: 100%;
            }

            .desc-line {
                text-align: left;
                line-height: 1.3;
            }

            @media(max-width:900px) {
                .card-body {
                    flex-direction: column
                }

                .right {
                    width: 100%;
                    border-left: none;
                    border-top: 1px solid #eef2f7
                }
            }

            /* Tooltip styles (fallback when Bootstrap JS not present) */
            .simple-tooltip {
                position: fixed;
                z-index: 2000;
                max-width: 920px;
                width: min(96vw, 920px);
                background: #fff;
                color: #111;
                border: 1px solid rgba(0, 0, 0, 0.08);
                box-shadow: 0 14px 50px rgba(17, 24, 39, 0.14);
                padding: 16px;
                border-radius: 12px;
                font-size: 15px;
                overflow: auto
            }

            .simple-tooltip .tt-head {
                display: block;
                font-weight: 700;
                margin-bottom: 8px
            }

            .simple-tooltip .tt-body {
                font-size: 13px;
                color: var(--muted);
                line-height: 1.45
            }

            .simple-tooltip img {
                max-width: 100%;
                height: auto;
                border-radius: 6px;
                display: block;
                margin-top: 8px
            }

            .simple-tooltip ul {
                margin: 8px 0 0 18px;
                padding: 0
            }

            .simple-tooltip li {
                margin: 6px 0
            }

            @media (max-width:620px) {
                .simple-tooltip {
                    max-width: calc(100% - 32px);
                    left: 16px !important;
                    right: 16px !important;
                    font-size: 14px
                }
            }
        </style>
    </head>

    <script type="text/javascript">
        var Tawk_API = Tawk_API || {},
            Tawk_LoadStart = new Date();
        (function() {
            var s1 = document.createElement("script"),
                s0 = document.getElementsByTagName("script")[0];
            s1.async = true;
            s1.src = 'https://embed.tawk.to/68249d278984c1190f3ac001/1ir7gboti';
            s1.charset = 'UTF-8';
            s1.setAttribute('crossorigin', '*');
            s0.parentNode.insertBefore(s1, s0);
        })();
    </script>
    <!--End of Tawk.to Script-->


    <section id="wrap">
        <header id="header">
            <section class="desktop-nav" id="header-top">
                <div class="container">
                    <div class="row">
                        <div class="col-xs-4">
                            <h1 id="logo" style="margin-left: -12%;"><a title="25PoundLogoDesign "
                                    href="/Sale/"><img class="img-responsive"
                                        src="assets/images/new-nav-logo.webp"
                                        style="height: 100px !important; width: 350px  !important; object-fit:contain; mix-blend-mode:multiply; background-color: transparent;" /></a>
                            </h1>
                        </div>
                        <div class="col-xs-4">
                            <aside class="clearfix" id="right-section">
                                <ul class="list-unstyled head-list" style="line-height: 1.7rem; margin-bottom: 2px;">
                                    <li
                                        style="color:#222; font-size: 1.6rem;font-weight:600; text-align: center;margin-top: 25px;">
                                        Far Better than AI!
                                    </li>

                                    <li class="custom-tooltip" style="color: #222; font-size: 1.6rem; font-weight: 600">
                                        Hand-Drawn Logos = <u> The Highest Qualit</u>y!
                                        <a class="test1 top-tooltip" data-toggle="tooltip" data-placement="bottom"
                                            data-html="true" data-max-width="550px" title="" data-original-title="
                                            <span class='tt-head'>25PoundLogoDesign</span><br/>
      <span class='tt-head' style='background: yellow; padding: 0px 4px; border-radius: 4px;'><span style='color: red;'>With our Sale</span>, now much more affordable than others!</span><br>
        <span class='tt-head' style='background: yellow; padding: 0px 4px; border-radius: 4px;'>Save Money, Time and Get a Far Higher Quality Logo!...</span><br/><br/>
      <ul class=''>
        
        <li class=''>✔  Each logo is <u>meticulously hand-drawn</u>, adding a level of detail<br>
        and sophistication that sets our work apart  far better than AI!</li>
        <li class=''>✔ 100% of our designers hold accredited graphic design degrees.</li>
        
        
        
      </ul>
      <h2 style='font-size: 18px; font-weight: 500; margin-bottom:8px;' > Far Higher Quality than AI logo makers!<br>
        <u>ONLY</u> with us are your logos hand-drawn.<br>
        Get the Very Highest Possible Quality!
      </h2>
      <img src='assets/images/video-image-new.webp' style='height:35%; width:45%; border-radius:5px'><br>
      <h2 style='font-size: 18px; font-weight: 500; margin-top:6px; margin-bottom: 10px' >   Our Professional Designers use<br> the Most Advanced Hand-Held Tablets.
      </h2>
      <h2 style='font-size: 18px; font-weight: 500; margin-bottom:-10px;'>Other providers:</h2><br/>
      <ul class=''>
        <li class=''>✔ They rely on pre-made templates (like AI), resulting in logos that<br> look cheap  and many copyright issues.</li>
        <li class=''>✔ They often outsource (usually to India) whilst using London PO <br> Box addresses.</li>
      </ul>">
                                            <img src="assets/images/added/silver-info.jpg" style="margin-top: 3px" />
                                        </a>
                                    </li>

                                    <li
                                        style="color:#222; font-size: 1.6rem;font-weight:600; background-color: rgb(255, 255, 199); text-align: center; white-space: nowrap; width:fit-content; padding: 2px;">
                                        With our Sale, now much more affordable too!
                                    </li>
                                </ul>
                            </aside>
                        </div>
                        <div class="col-xs-4">

                            <div class="pull-right r-cont">

                                <h2 style="font-size: 20px; font-weight: 700; color: #000; margin-bottom:2px;"><img
                                        src="assets/images/phone.png" height="20px" width="20px" alt="call-phone"><span
                                        class="call-support">24/7 <em style="color: #00af50; font: weight 600px;"
                                            class="color"> Devoted </em> Support</span><span class="trademark"></span>
                                </h2>
                                <div class="info-box" style="margin-left: 15px;">
                                    <p class="text-left" style="margin-bottom:2px;">
                                        <a style="font-size: 12px; font-weight: 700; position: relative;
                                            top: 0px; color: #272727;" href="#">Sales/Support </a><span
                                            style="font-size: 16px; color: #00af50;; font-weight: 600;  " class="ph-no">020 3151 0816</span>
                                    </p>
                                    <p class="text-right"
                                        style="margin-bottom:2px;margin-right:10px;text-align:center!important">
                                        <a style="font-size: 1.2rem; font-weight: 600; color: #333; color:#333;"
                                            class="live-chat" href="javascript:void(0);">Live chat <img
                                                src="assets/images/hi-bubble.png" alt="hi" width="32" height="28" /></a>
                                        </a></span>
                                    </p>
                                </div>
                                <nav>
                                    <ul class="nav1 navbar-nav1 " style="position: absolute;
                                            right:0px;
                                            top: 32px;">
                                        <li id=" login">

                                            <div id="login-content">
                                                <a target="_blank">Logo
                                                    Client Panel</a>
                                                <a target="_blank">Web
                                                    Client Panel</a>
                                            </div>
                                        </li>

                                    </ul>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </section>




            <section class="mobile-nav" style="padding:15px 0px;">
                <div class="row">
                    <div class="col-xs-3">
                    </div>
                    <div class="col-xs-6">
                        <h1 id="logo" style="margin-left: -24%; margin-right: -14%;"><a title="25PoundLogoDesign "
                                href="/Sale/"><img class="img-responsive"
                                    src="assets/images/mobile-view-logo-copy.webp" style="height: 40px !important" ; /></a>
                        </h1>
                    </div>
                    <div class="col-xs-3" style="text-align: center;">
                        <a style="font-weight: 600; color: #000; font-size: 1rem; display: inline-block; margin-top: -18px;"
                            class="phone-text" data-toggle="modal" data-target="#myModal">
                            &#20;<img src="assets/images/phone.png" height="30px" width="30px" alt="phone-two">
                            <br>Call 24/7
                        </a>
                    </div>
                </div>
            </section>

            <!-- Add an overlay div for the entire screen -->
            <div id="overlay"
                style="display: none; position: fixed; top: 0; left: 0;  width: 100%; height: 100%; background-color: rgba(0, 0, 0, 0.5); z-index: 999;">
            </div>

            <!-- Close button for mobile view (initially hidden) -->
            <li style="position: absolute; top: 0; right: 0rem; padding: 1rem; z-index: 1000; display: none !important;"
                id="closeButtonContainer">
                <button type="button" style="background-color: transparent;" class="close-menu"
                    onclick="closeMobileNavbar()">
                    <span class="cross-icon">&#10005;</span>
                </button>
            </li>


            <style>
                .small-banner {

                    background-color: #ffff00;
                    padding: 10px;
                    text-align: center;
                }

                .small-banner-text {
                    color: black;
                    font-weight: 600;
                    font-size: 1.4rem;
                }

                @media (max-width: 700px) {
                    .small-banner {
                        padding: 1px;
                    }

                    .small-banner-text {
                        font-size: 1.4rem;
                    }
                }

                @media (min-width: 700px) {
                    .small-banner {
                        padding: 3px;
                    }

                    .small-banner-text {
                        font-size: 1.4rem;
                        white-space: nowrap;
                    }
                }

                .small-banner {
                    margin-top: 10px;
                    width: fit-content;
                }
            </style>
            <style>
                .percent-off {
                    background: #FF0000;
                    border-bottom: 2px solid #e67c00;
                    display: inline-block;
                    width: fit-content;
                    padding: 2px 9px;
                    color: #fff;
                    text-transform: uppercase;
                    font-family: 'Helvetica Neue', sans-serif;
                    border-radius: 5px;
                    margin-top: 10px;
                    display: flex;
                    align-items: center;
                }

                .main-text {
                    font-size: 50px;
                    font-weight: bold;
                    margin-right: 10px;
                }

                .sub-text {
                    display: flex;
                    flex-direction: column;
                    align-items: flex-start;
                    font-weight: bold;
                }

                .sub-text .percent {
                    font-size: 50px;
                }

                .sub-text .off {
                    font-size: 50px;
                }

                /* Media query for mobile devices */
                @media (max-width: 768px) {
                    .percent-off {
                        width: 60%;
                    }
                }
            </style>
            <style type="text/css">
                nav #login-content:before {
                    content: '';
                    display: inline-block;
                    border-left: 18px solid transparent;
                    border-right: 18px solid transparent;
                    border-bottom: 18px solid #EFEFEF;
                    position: absolute;
                    top: -6px;
                    right: 6px;
                }

                nav #login-content {
                    display: none;
                    position: absolute;
                    top: 24px;
                    right: 0;
                    z-index: 999;
                    padding: 15px;
                    width: 200px;
                    background-color: #EFEFEF;
                    -webkit-background-clip: padding-box;
                    background-clip: padding-box;
                    border: 1px solid #EFEFEF;
                    -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, .2);
                    box-shadow: 0 5px 10px rgba(0, 0, 0, .2);
                }

                nav li #login-content {
                    right: 0;
                }

                #login-content a {
                    display: block;
                    clear: both;
                    color: grey !important;
                    font-weight: 400 !important;
                    font-size: 15px;
                }

                nav #login-trigger,
                nav #signup a {
                    display: inline-block;
                    *display: inline;
                    *zoom: 1;
                    height: 25px;
                    line-height: 25px;
                    font-weight: 400;
                    padding: 0 8px;
                    text-decoration: none;
                    color: grey !important;
                    text-shadow: 0 1px 0 #fff;
                }

                .fa-chevron-down,
                .fa-chevron-up {
                    font-size: 10px;
                }
            </style>

            <script type="text/javascript">
                $(document).ready(function() {

                    $('#login-trigger').click(function(e) {
                        e.preventDefault();
                        e.stopPropagation();
                        $(this).next('#login-content').slideToggle();
                        $(this).toggleClass('active12');

                        if ($(this).hasClass('active12')) $(this).find('span').html('<i class="fa fa-chevron-up" aria-hidden="true"></i>')
                        else $(this).find('span').html('<i class="fa fa-chevron-down" aria-hidden="true"></i>')
                    });

                    $('#login-content').click(function(e) {
                        e.stopPropagation();
                    });

                    $(document).click(function() {
                        $('#login-content').slideUp();
                    });
                });
            </script>
        </header>
        <style>
            @media screen and (-webkit-min-device-pixel-ratio:0) {

                /* Safari only override */
                ::i-block-chrome,
                .hero-flag-text p {
                    font-family: 'PT Sans', sans-serif, Arial, Verdana !important;
                    font-weight: 700 !important;
                }
            }

            .information {
                width: 100%;
                max-width: 360px;
                margin-left: -6%;
            }
        </style>

        <script>
            $(document).ready(function() {
                // Enable tooltips
                $('[data-toggle="tooltip"]').tooltip();
            });

            $(function() {
                var delay = 200; // Delay in milliseconds (1 second)

                // Function to show or hide banner with delay
                function animateBanner() {
                    setTimeout(function() {
                        if ($(window).scrollTop() > 100) {
                            $(".banner").hide()
                            $(".banner").stop().slideUp('slow');
                        } else {
                            $(".banner").show()
                            $(".banner").stop().slideDown('slow');
                        }
                    }, delay);
                }
                // Call the function on page load and scroll
                animateBanner();

                $(window).scroll(function() {
                    animateBanner();
                });
            });
        </script>

        <script>
            function closeNavbar() {
                $('#main-nav').collapse('hide'); // Utilize Bootstrap's Collapse plugin to hide the navbar
            }
        </script>

        <script>
            function closeMobileNavbar() {
                // Fade out the close button and overlay
                $('#closeButtonContainer').fadeOut();
                $('#overlay').fadeOut();
                closeNavbar();
            }

            $('#main-nav').on('show.bs.collapse', function() {
                // Show the close button and overlay when the Bootstrap menu is toggled on
                $('#closeButtonContainer').fadeIn();
                $('#overlay').fadeIn();
            });

            $('#main-nav').on('hide.bs.collapse', function() {
                // Hide the overlay when the Bootstrap menu is toggled off
                $('#overlay').fadeOut(200);
            });

            $('#overlay').on('click', function() {
                console.log('Overlay clicked');
                closeMobileNavbar(); // Assuming you have a function to close the navbar
            });
        </script>


        <script>
            function toggleSubmenu() {
                var submenu = document.getElementById('web-design-menu');
                var arrow = document.getElementById('web-design-arrow');
                if (submenu.style.display === 'none' || submenu.style.display === '') {
                    submenu.style.display = 'block';
                    arrow.classList.remove('fa-arrow-down');
                    arrow.classList.add('fa-arrow-up');
                } else {
                    submenu.style.display = 'none';
                    arrow.classList.remove('fa-arrow-up');
                    arrow.classList.add('fa-arrow-down');
                }
            }

            document.getElementById('web-design-link').addEventListener('click', toggleSubmenu);
            document.getElementById('web-design-arrow').addEventListener('click', toggleSubmenu);

            document.getElementById('show-less-link').addEventListener('click', function() {
                var submenu = document.getElementById('web-design-menu');
                var arrow = document.getElementById('web-design-arrow');
                submenu.style.display = 'none';
                arrow.classList.remove('fa-arrow-up');
                arrow.classList.add('fa-arrow-down');
            });
        </script>

        <script>
            document.getElementById("packages-arrow").addEventListener("click", function() {
                window.location.href = document.getElementById("packages-link").getAttribute("href");
            });

            document.getElementById("process-arrow").addEventListener("click", function() {
                window.location.href = document.getElementById("process-link").getAttribute("href");
            });
            document.getElementById("compare-us-arrow").addEventListener("click", function() {
                window.location.href = document.getElementById("compare-us-link").getAttribute("href");
            });
            document.getElementById("portfolio-arrow").addEventListener("click", function() {
                window.location.href = document.getElementById("portfolio-link").getAttribute("href");
            });
            document.getElementById("about-us-arrow").addEventListener("click", function() {
                window.location.href = document.getElementById("about-us-link").getAttribute("href");
            });
        </script>

        <style>
            .tooltip-inner {
                left: -11rem;
            }
        </style>
        <script>
            $(document).ready(function() {
                $('[data-toggle="tooltip"]').tooltip();
            });
        </script>

        <div class="information">
            <aside class="clearfix" id="right-section">
                <ul class="list-unstyled head-list">
                    <li style="
                            color: #222;
                            font-size: 1.6rem;
                            font-weight: 600;
                            text-align: center;
                        ">
                        Far Better than AI!
                    </li>
                    <li class="custom-tooltip" style="color: #222; font-size: 1.6rem; font-weight: 600">
                        Hand-Drawn Logos = <u> The Highest Qualit</u>y!
                        <a class="test1 top-tooltip" data-toggle="tooltip" data-placement="bottom" data-html="true"
                            data-max-width="550px" title="" data-original-title="
                            <span class='tt-head'>25PoundLogoDesign</span><br/>
                                <span style='background: yellow; padding: 1px 6px; border-radius: 4px; display: inline-block;'>
                                    <span class='tt-head'>
                                    <span style='color: red;'>With our Sale</span>, 
                                    now much more affordable than others!<br>
                                    Save Money, Time and Get a Far Higher Quality Logo!...</span>
                                </span><br/><br/>
                                <ul class=''>
                                    <li class=''>✔  Each logo is <u>meticulously hand-drawn</u>, adding a level of detail<br>
                                    and sophistication that sets our work apart  far better than AI!</li>
                                    <li class=''>✔ 100% of our designers hold accredited graphic design degrees.</li>
                                </ul>
                                <h2 style='font-size: 18px;' > Far Higher Quality than<br> AI logo makers!<br>
                                    <u>ONLY</u> with us are your logos<br> hand-drawn.<br>
                                    Get the Very Highest Possible<br> Quality!
                                </h2>
                                <img src='assets/images/video-image-new.webp' style='height:35%; width:45%; border-radius:5px'><br>
                                <h2 style='font-size: 18px; margin-top:6px' > Our Professional Designers use<br> the Most Advanced Hand-Held Tablets.</h2>
                                <h2 style='font-size: 18px; font-weight: 500; margin-bottom:-10px;'>Other providers:</h2><br/
                                ><ul class=''>
                                <li class=''>✔ They rely on pre-made templates (like AI), resulting in logos that<br> look cheap  and many copyright issues</li>
                                <li class=''>✔ They often outsource (usually to India) whilst using London PO <br> Box addresses.</li>
                                </ul>">
                            <img src="assets/images/added/silver-info.jpg" style="margin-top: 3px" />
                        </a>
                    </li>

                    <li style="
                            color: #222;
                            font-size: 1.6rem;
                            font-weight: 600;
                            background-color: rgb(255, 255, 199);
                            text-align: center;
                            width: fit-content;
                            padding: 2px;
                        ">
                        With our Sale, now much more affordable too!
                    </li>
                </ul>
                <hr>
            </aside>
        </div>

        <section id="inner-cont-banner" style="position:relative;">
            <section>
                <div class="banner" style="background-color:#ffff00; top: 0 !important;">
                    <span class="text-center banner-text" data-sale=true">
                        New Customer Special: Get 50% Off Your 1st Order!
                    </span>
                    <span class="banner-text-two">Applies to All Logo Design Packages.</span>
                </div>
            </section>
            <div id="mycarousel" class="carousel video_carousel_fade animate_text" data-ride="carousel" data-interval="8000">
            </div>
        </section>
        <style>
            .price-container {
                display: flex;
                align-items: baseline;
                font-family: 'Helvetica Neue', sans-serif;
                color: #333;
                gap: 6px;
            }

            .price-container h4 {
                font-size: 3rem;
                margin: 0;
                display: flex;
                align-items: baseline;
                color: red;
                font-weight: 600;
            }

            .price-container .currency {
                font-size: 1.5rem;
                align-self: flex-start;
                margin-left: 4px;
                margin-top: 2.5px;
                color: red;
                font-weight: 600;
            }

            .price-container .main_price {
                font-size: 3rem;
                font-weight: bold;
                color: red;
            }

            .save-pack1 {
                font-size: 1.5rem;
                color: #414141 !important;
                ;
            }

            .save-pack1 span {
                font-size: 2rem;
                font-weight: bold;
                margin-left: 1px;
                color: rgb(68, 68, 68);
            }

            .save-pack1 .save-cross1 {
                text-decoration: line-through;
            }

            .multi-color-box .body.blue strong {
                color: #171818;
            }

            .multi-color-box .body.green strong {
                color: #151514;
            }

            .price-container {
                margin-top: 10px;
            }
        </style>


        <style>
            .orange-button {
                background-color: #F06E00;
                padding: 3px 0px;
                border bottom: 3px solid #c05700;
                font-family: "Walsheim-Bold" !important;
                font-size: 24px !important;
                line-height: 2.2 !important;
                font-family: "Walsheim-Bold" !important;
                font-style: normal;
                font-weight: 400;
            }

            .green-button {
                background-color: #7db701;
                padding: 3px 0px;
                border-bottom: 3px solid #578307;
                font-size: 24px !important;
                line-height: 2.2 !important;
                font-family: "Walsheim-Bold" !important;
                font-style: normal;
                font-weight: 400;
            }

            .order-pack {
                font-size: 24px !important;
                line-height: 2.2 !important;
                font-family: "SegoeUISemilight" !important;
                font-style: normal;
                font-weight: 400;
                width: auto;
                padding-left: 27px;
                padding-right: 27px;
                border-radius: 3px;
            }

            .forMH {
                background-color: white;
                color: black;
            }


            @media only screen and (max-width: 767px) {

                html,
                body {
                    overflow-x: hidden;
                }

                .recent-work {
                    margin-left: 1.5rem;
                    margin-top: 1rem;
                }

                .detail .tooltip-inner {
                    left: 0;
                    min-width: 350px;
                }

                #sief-design-process .title div {
                    height: auto;
                    line-height: 1;
                    text-align: center;
                }

                .main-text {
                    font-size: 50px;
                    font-weight: bold;
                    margin-right: 10px;
                }

                .pt-5 {
                    padding-top: 7rem;

                }

                .pt-8 {
                    padding-top: 9rem;
                }
            }


            @media (max-width: 415px) {

                hr {
                    margin-top: 5px;
                    width: 100% !important;
                    margin-bottom: 20px;
                    border: 0;
                    border-top: 1px solid #ebebeb;
                    margin-left: 0px !important;
                }

                html,
                body {
                    overflow-x: hidden;
                }

                .text-left {
                    text-align: left;
                }

                .banner-desc ul li {

                    font-size: 1.8rem !important;
                }

                .banner-caption-head {
                    margin-top: 160px;
                }

                .recent-work {
                    margin-top: 20px;
                }

                .list-unstyled {
                    text-align: center;
                    margin: auto;
                    margin-right: 22px;
                    margin-left: -5%;
                }


                .forMH {
                    background: url(../assets/images/color-box-orange.jpg) repeat scroll 0 0 rgba(0, 0, 0, 0);
                    color: white;
                }

                .forMH1 {
                    background: url(../assets/images/color-box-blue.jpg) repeat scroll 0 0 rgba(0, 0, 0, 0);
                    color: white;
                }

                .forMH2 {
                    background: url(../assets/images/color-box-green.jpg) repeat scroll 0 0 rgba(0, 0, 0, 0);
                    color: white;
                }

                .percent-off {
                    width: 180px;
                }



            }
        </style>

    </section>

    <body>
        <div class="sim-header">
            <img class="logo" src="assets/images/new-nav-logo.webp" alt="25PoundLogoDesign">
            <div>
                <div class="site-title">25PoundLogoDesign  Secure Checkout</div>
                <div class="site-sub">Hand-drawn logos  fast, affordable, guaranteed</div>
            </div>
        </div>

        <div class="card">
            <div class="card-body">
                <div class="left">
                    <h2 class="h">Secure payment</h2>
                    <p class="muted">You're paying for your selected package. This page simulates the Nochex payment flow for local testing.</p>

                    <div style="margin-top:18px;">
                        <div class="order-row">
                            <div class="small">Order</div>
                            <div><strong><?php echo htmlspecialchars($order_id); ?></strong></div>
                        </div>
                        <div class="order-row">
                            <div class="small">Package</div>
                            <div><?php echo htmlspecialchars($package_name); ?></div>
                        </div>
                        <div class="order-row" style="align-items:flex-start;">
                            <div class="small">Description</div>
                            <div class="small desc-list">
                                <?php foreach ($description_items_html as $line): ?>
                                    <div class="desc-line"><?php echo $line; ?></div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                        <div class="order-row">
                            <div class="small">Amount</div>
                            <div class="amount">�<?php echo htmlspecialchars($amount); ?></div>
                        </div>
                    </div>

                    <div style="margin-top:20px;">
                        <button id="auth" class="btn btn-pay" style="margin-right:12px">Simulate Authorised (Success)</button>
                        <button id="cancel" class="btn btn-cancel">Simulate Cancel</button>
                    </div>

                    <div class="trust">
                        <img src="assets/images/visa.gif" alt="visa">
                        <img src="assets/images/mastercard.gif" alt="mastercard">
                        <img src="assets/images/paypal.gif" alt="paypal">
                        <span class="muted" style="margin-left:8px">Secure test environment  no real charges</span>
                    </div>
                </div>

                <div class="right">
                    <h3 class="h">Payment summary</h3>
                    <p class="small">Order ID<br><strong><?php echo htmlspecialchars($order_id); ?></strong></p>
                    <p class="small">Package<br><strong><?php echo htmlspecialchars($package_name); ?></strong></p>
                    <p class="small">Description</p>
                    <div class="small desc-list" style="margin-top:-6px;">
                        <?php foreach ($description_items_html as $line): ?>
                            <div class="desc-line"><strong><?php echo $line; ?></strong></div>
                        <?php endforeach; ?>
                    </div>
                    <hr>
                    <p class="small">Total</p>
                    <div class="amount">�<?php echo htmlspecialchars($amount); ?></div>
                    <p class="muted" style="margin-top:10px">You will be redirected back to the site after payment.</p>
                    <div style="margin-top:14px">
                        <a href="/Sale/checkout-secondpage.html" style="text-decoration:none"><button class="btn" style="background:#eef2f7;border-radius:8px;padding:10px 14px">Return to checkout</button></a>
                    </div>
                </div>
            </div>
        </div>

        <script>
            document.getElementById('auth').addEventListener('click', function() {
                // POST to callback then redirect to success
                fetch('<?php echo $simPostUrl; ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded'
                    },
                    body: new URLSearchParams({
                        order_id: '<?php echo addslashes($order_id); ?>',
                        amount: '<?php echo addslashes($amount); ?>',
                        customer_email: '<?php echo addslashes($customer_email); ?>',
                        transaction_result: 'AUTHORISED'
                    })
                }).then(function(resp) {
                    // ignore body, redirect to success
                    window.location.href = '<?php echo $successUrl; ?>?order_id=<?php echo urlencode($order_id); ?>';
                }).catch(function() {
                    alert('Callback POST failed  check server logs');
                });
            });

            document.getElementById('cancel').addEventListener('click', function() {
                window.location.href = '<?php echo $cancelUrl; ?>?order_id=<?php echo urlencode($order_id); ?>';
            });
        </script>

        <script src="//code.jquery.com/jquery-migrate-1.2.1.min.js"></script>

        <script src="assets/js/modernizr.custom.js"></script>
        <!-- Include all compiled plugins (below), or include individual files as needed -->
        <script src="assets/js/bootstrap.min.js"></script>
        <script src="assets/js/custom.js"></script>
        <script src="assets/js/jquery.loadmask.min.js"></script>
        <script>
            window.addEventListener('DOMContentLoaded', () => {
                document.documentElement.classList.add('loaded');
            });
        </script>


    </body>

    </html>
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip()
        });
    </script>
    <link href="assets/css/custom.css" rel="stylesheet">

    </body>

    </html>
<?php
    exit;
}

// Render an auto-submitting form to Nochex. Field names may need to be adjusted
// to match the exact Nochex integration you're using (merchant_id vs merchant_email, callback names, etc.).
// Nochex field names differ between integrations; update as required by your account.
?>
<!doctype html>
<html>

<head>
    <meta charset="utf-8">
    <title>Redirecting to Nochex...</title>
</head>

<body>
    <form id="nochex" action="<?php echo htmlspecialchars($NOCHEX_URL); ?>" method="post">
        <!-- Use merchant_email for many Nochex integrations; keep both to be safe -->
        <input type="hidden" name="merchant_email" value="<?php echo htmlspecialchars($MERCHANT_ID); ?>">
        <input type="hidden" name="merchant_id" value="<?php echo htmlspecialchars($MERCHANT_ID); ?>">
        <input type="hidden" name="amount" value="<?php echo htmlspecialchars($amount); ?>">
        <input type="hidden" name="order_id" value="<?php echo htmlspecialchars($order_id); ?>">
        <input type="hidden" name="description" value="<?php echo htmlspecialchars($description_for_nochex); ?>">
        <input type="hidden" name="customer_email" value="<?php echo htmlspecialchars($customer_email); ?>">
        <input type="hidden" name="email_address" value="<?php echo htmlspecialchars($customer_email); ?>">
        <input type="hidden" name="hide_billing_details" value="1">
        <!-- Common callback field names -- adjust if your Nochex account expects different names -->
        <input type="hidden" name="success_url" value="<?php echo htmlspecialchars($SUCCESS_URL); ?>">
        <input type="hidden" name="cancel_url" value="<?php echo htmlspecialchars($CANCEL_URL); ?>">
        <input type="hidden" name="merchant_notify_url" value="<?php echo htmlspecialchars($NOTIFY_URL); ?>">
        <?php if ($TEST_MODE): ?>
            <input type="hidden" name="test_transaction" value="100">
            <input type="hidden" name="test_success_url" value="<?php echo htmlspecialchars($TEST_SUCCESS_URL); ?>">
        <?php endif; ?>
        <!-- Add any other fields required by your Nochex account here -->
        <noscript>
            <p>Please click the button below if you are not redirected automatically.</p>
            <button type="submit">Continue to Nochex</button>
        </noscript>
    </form>
    <script>
        document.getElementById('nochex').submit();
    </script>
</body>

</html>
