﻿<?php
// Success landing page after Nochex payment
$logFile = __DIR__ . '/nochex_requests.log';
$entry = sprintf("%s | Success redirect | GET=%s\n", date('c'), json_encode($_GET));
file_put_contents($logFile, $entry, FILE_APPEND | LOCK_EX);

$orderId = isset($_GET['order_id']) ? trim((string)$_GET['order_id']) : '';
if ($orderId === '' && isset($_COOKIE['last_order_id'])) {
    $orderId = trim((string)$_COOKIE['last_order_id']);
}
$amount = isset($_GET['amount']) ? trim((string)$_GET['amount']) : '';
$transactionId = isset($_GET['transaction_id']) ? trim((string)$_GET['transaction_id']) : '';
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Thank You - Payment Received</title>
    <style>
        :root {
            --ink: #0f172a;
            --muted: #475569;
            --line: #dbe3ef;
            --primary: #0d5db8;
            --accent: #16a34a;
            --paper: #ffffff;
            --bg1: #f8fbff;
            --bg2: #edf5ff;
        }
        * { box-sizing: border-box; }
        body {
            margin: 0;
            font-family: "Segoe UI", Tahoma, Arial, sans-serif;
            color: var(--ink);
            background: radial-gradient(1200px 600px at 8% 0%, #d8e9ff 0%, transparent 45%),
                        linear-gradient(180deg, var(--bg1), var(--bg2));
            min-height: 100vh;
            display: grid;
            place-items: center;
            padding: 28px 16px;
        }
        .wrap {
            width: 100%;
            max-width: 880px;
            background: var(--paper);
            border: 1px solid var(--line);
            border-radius: 18px;
            overflow: hidden;
            box-shadow: 0 18px 44px rgba(13, 93, 184, 0.14);
        }
        .top {
            background: linear-gradient(135deg, #0d5db8, #0a4f9f);
            color: #fff;
            padding: 26px 24px;
            position: relative;
        }
        .badge {
            display: inline-flex;
            align-items: center;
            gap: 10px;
            background: rgba(255, 255, 255, 0.14);
            border: 1px solid rgba(255, 255, 255, 0.28);
            border-radius: 999px;
            padding: 8px 14px;
            font-weight: 700;
            font-size: 14px;
        }
        .badge i {
            width: 18px;
            height: 18px;
            border-radius: 50%;
            background: #22c55e;
            display: inline-block;
            position: relative;
        }
        .badge i::after {
            content: "";
            position: absolute;
            left: 5px;
            top: 3px;
            width: 6px;
            height: 10px;
            border: solid #fff;
            border-width: 0 2px 2px 0;
            transform: rotate(45deg);
        }
        h1 {
            margin: 14px 0 8px;
            font-size: clamp(24px, 3vw, 34px);
            line-height: 1.1;
        }
        .subtitle {
            margin: 0;
            color: rgba(255, 255, 255, 0.92);
            font-size: 16px;
        }
        .body {
            padding: 24px;
            display: grid;
            gap: 18px;
        }
        .meta {
            border: 1px solid var(--line);
            border-radius: 12px;
            overflow: hidden;
        }
        .row {
            display: grid;
            grid-template-columns: 180px 1fr;
            gap: 8px;
            padding: 12px 14px;
            border-bottom: 1px solid var(--line);
        }
        .row:last-child { border-bottom: 0; }
        .label {
            color: var(--muted);
            font-weight: 600;
        }
        .val {
            font-weight: 700;
            word-break: break-word;
        }
        .steps {
            border: 1px solid var(--line);
            border-radius: 12px;
            padding: 16px;
        }
        .steps h2 {
            margin: 0 0 10px;
            font-size: 18px;
        }
        .steps ul {
            margin: 0;
            padding-left: 18px;
            color: var(--muted);
            line-height: 1.7;
        }
        .actions {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            margin-top: 4px;
        }
        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            text-decoration: none;
            border-radius: 10px;
            font-weight: 700;
            padding: 11px 16px;
            border: 1px solid transparent;
        }
        .btn-primary {
            background: var(--primary);
            color: #fff;
        }
        .btn-primary:hover { background: #0a4f9f; }
        .btn-light {
            background: #fff;
            color: var(--ink);
            border-color: var(--line);
        }
        .btn-light:hover { background: #f8fafc; }
        .foot {
            color: #64748b;
            font-size: 13px;
        }
        @media (max-width: 680px) {
            .top, .body { padding: 18px; }
            .row { grid-template-columns: 1fr; }
            .label { font-size: 13px; }
        }
    </style>
</head>
<body>
    <main class="wrap">
        <section class="top">
            <span class="badge"><i></i> Payment Received</span>
            <h1>Thank you for your order</h1>
            <p class="subtitle">Your payment has been submitted successfully. We will process your order and email confirmation shortly.</p>
        </section>
        <section class="body">
            <section class="meta" aria-label="Payment Details">
                <div class="row">
                    <div class="label">Amount</div>
                    <div class="val"><?php echo htmlspecialchars($amount !== '' ? ('£' . $amount) : 'Provided on Nochex checkout'); ?></div>
                </div>
                <div class="row">
                    <div class="label">Transaction Reference</div>
                    <div class="val"><?php echo htmlspecialchars($transactionId !== '' ? $transactionId : '25PoundLogoDesign'); ?></div>
                </div>
                <div class="row">
                    <div class="label">Status</div>
                    <div class="val" style="color: var(--accent);">Payment Completed</div>
                </div>
            </section>

            <section class="steps">
                <h2>What Happens Next</h2>
                <ul>
                    <li>Your order record has been received by our system.</li>
                    <li>Our team reviews your selected package and starts creating your designs.</li>
                    <li>You will receive your designs via email shortly.</li>
                </ul>
            </section>

            <div class="actions">
                <a class="btn btn-primary" href="/Sale/packages">View Packages</a>
                <a class="btn btn-light" href="/Sale/">Back to Home</a>
            </div>

            <!-- <p class="foot">If you need help, contact support and share your Order ID for faster assistance.</p> -->
        </section>
    </main>
</body>
</html>
