<?php
require_once __DIR__ . '/db.php';
$orders = fetchOrders(200);
?>
<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>Orders Admin</title>
    <style>table{border-collapse:collapse;width:100%}td,th{border:1px solid #ddd;padding:8px}th{background:#f4f4f4}</style>
</head>
<body>
    <h1>Orders</h1>
    <table>
        <thead>
            <tr><th>ID</th><th>Order ID</th><th>Amount</th><th>Package</th><th>Status</th><th>Transaction</th><th>Created</th><th>Updated</th><th>Verified</th></tr>
        </thead>
        <tbody>
        <?php foreach($orders as $o): ?>
            <tr>
                <td><?php echo htmlspecialchars($o['id']); ?></td>
                <td><?php echo htmlspecialchars($o['order_id']); ?></td>
                <td><?php echo htmlspecialchars($o['amount']); ?></td>
                <td><?php echo htmlspecialchars($o['package_name']); ?></td>
                <td><?php echo htmlspecialchars($o['status']); ?></td>
                <td><?php echo htmlspecialchars($o['transaction_result']); ?></td>
                <td><?php echo htmlspecialchars($o['created_at']); ?></td>
                <td><?php echo htmlspecialchars($o['updated_at']); ?></td>
                <td><?php echo htmlspecialchars($o['verified_at']); ?></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</body>
</html>
